package aln.SpawnCommands;

import java.util.Arrays;
import java.util.List;

import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public class CommandSetHome implements ICommand {

  @Override
  public int compareTo(Object o) {
    return 0;
  }

  @Override
  public String getCommandName() {
    //return "sethome";
    return Do.getConfigArrayValue(SpawnCommands.commandNames ,"sethome");
  }

  @Override
  public String getCommandUsage(ICommandSender icommandsender) {
    return "/"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"sethome")+"   or  /"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"sethome")+" mybasename   to set bed or named locaions.";
  }

  @Override
  public List getCommandAliases() {
    return Arrays.asList(new String[] { });
  }

  @Override
  public void processCommand(ICommandSender icommandsender, String[] params) {
    if(icommandsender instanceof EntityPlayer) {
      EntityPlayer player = (EntityPlayer) icommandsender;
      if ( player.worldObj.isRemote ) { return; }
      
      SpawnCommands.loadCommandPermissionsConfig();
      SpawnCommands.loadMiscConfig();
      
      // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "sethome").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "sethome").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Advanced spawn commands are not enabled."); return; }
      
      if ( params.length == 0 ) 
      { SpawnCommands.SetBedSpawnPoint(player); return; }
      
      if ( (params.length > 1) || params[0].equalsIgnoreCase("help") ) 
      { SpawnCommands.showHelp(player); return; }
      
      // params.length == 1
      
      if ( ! Do.getConfigArrayValueBoolean(SpawnCommands.miscConfigArray,"HomeWithNamedLocations") )
      { Do.Say(player,"Using /"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"home")+" and /"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"sethome")+" with named locations is not enabled in the misc config file."); return; }
      
      SpawnCommands.commandSpawnPlus(player, params);
      
    } // end is player
  }
  
  @Override
  public boolean canCommandSenderUseCommand(ICommandSender icommandsender) {
    return true;
  }
  
  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring) { // mc1.7.10
    return null;
  }
  
  @Override
  public boolean isUsernameIndex(String[] astring, int i) {
    return false;
  }
  
}
